/**************************************************************************
 **                                                                      **
 ** DirectDraw Video Interface - Aron, 1998.06.17.                       **
 **                                                                      **
 **************************************************************************/

//#define  DEBUG

// - szabvany headerfile-ok -----------------------------------------------
#include "c:\Program Files\DX5SDK\sdk\inc\ddraw.h"

// - sajat headerfile-ok --------------------------------------------------
#include "video.hpp"

// - implementacio --------------------------------------------------------
LPDIRECTDRAW lpDD;
LPDIRECTDRAWSURFACE lpDDSPrimary,lpDDSBack;

#ifdef DEBUG
FILE *fpDD;
#endif

// - rendszerfunkciok -----------------------------------------------------
HRESULT InitVideoSystem(HWND hWnd,DWORD dwWidth,DWORD dwHeight,DWORD dwBPP)
{
	HRESULT error;

	// DD objektum krealasa a primary videodriver-rel:
    DDTRY("DDCreate",DirectDrawCreate(NULL,&lpDD,NULL);)

    // teljes kepernyon valo futas:
    DDTRY("SetCoopLevel",lpDD->SetCooperativeLevel(hWnd,DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE);)
	
    // videomod bekapcsolasa:
	DDTRY("SetDispMode",lpDD->SetDisplayMode(dwWidth,dwHeight,dwBPP);)

    // primary surface krealasa:
    DDSURFACEDESC ddsd;

    ZeroMemory(&ddsd,sizeof(ddsd));
    ddsd.dwSize= sizeof(ddsd);
    ddsd.dwFlags= DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	// VIDEO ramba!!!
    ddsd.ddsCaps.dwCaps= DDSCAPS_PRIMARYSURFACE | DDSCAPS_SYSTEMMEMORY | DDSCAPS_COMPLEX | DDSCAPS_FLIP;
	ddsd.dwBackBufferCount= 1;
	DDTRY("CrPrimSurf",lpDD->CreateSurface(&ddsd,(LPDIRECTDRAWSURFACE FAR *)&lpDDSPrimary,NULL);)

    // back surface lekerdezese:
    DDSCAPS ddscaps;

  	ddscaps.dwCaps= DDSCAPS_BACKBUFFER | DDSCAPS_SYSTEMMEMORY;
	DDTRY("GetAttach",lpDDSPrimary->GetAttachedSurface(&ddscaps,&lpDDSBack);)
	
	return DD_OK;
}

void CloseVideoSystem(void)
{
	// DirectDraw objektumok felszabaditasa:
    if(lpDD != NULL)
    {
		// eredeti videomod visszaallitasa:
        lpDD->RestoreDisplayMode();

        // back surface felszabaditasa:
		lpDDSPrimary->DeleteAttachedSurface(0,NULL);
		DDRELEASE(lpDDSBack);

		// primary surface felszabaditasa:
		DDRELEASE(lpDDSPrimary);

		// DDraw objektum felszabaditasa:
        DDRELEASE(lpDD);
	}
}

HRESULT FlipSurfaces(void)
{
	HRESULT ddrval;

	while(TRUE)
    {
		ddrval= lpDDSPrimary->Flip(NULL,DDFLIP_WAIT);

        if(ddrval == DDERR_SURFACELOST)
        {
			ddrval= lpDDSPrimary->Restore();
            if(ddrval != DD_OK) break;
        }
        if(ddrval != DDERR_WASSTILLDRAWING) break;
    }

    return ddrval;
}

HRESULT CopySurface(LPDIRECTDRAWSURFACE lpDDSDestination,LPDIRECTDRAWSURFACE lpDDSSource)
{
    // a teljes surface-t atmasoljuk effektek nelkul:
    return lpDDSDestination->Blt(NULL,lpDDSSource,NULL,DDBLT_WAIT,NULL);
}

HRESULT ClearSurface(LPDIRECTDRAWSURFACE lpDDSDestination)
{
    DDBLTFX fx;

    ZeroMemory(&fx,sizeof(DDBLTFX));
    fx.dwSize= sizeof(DDBLTFX);

    // a teljes surface-t toroljuk:
    return lpDDSDestination->Blt(NULL,NULL,NULL,DDBLT_WAIT | DDBLT_COLORFILL,&fx);
}

// - autodetektalo rutinok ------------------------------------------------
DWORD dwVideoModesAvailable;

HRESULT WINAPI DDEnumDisplayModesCallback(LPDDSURFACEDESC lpDDSurfaceDesc,LPVOID lpContext)
{
	// flag kitoltese:
	if((lpDDSurfaceDesc->dwWidth == 320) && (lpDDSurfaceDesc->dwHeight == 200))
	{
		if(lpDDSurfaceDesc->ddpfPixelFormat.dwRGBBitCount == 16) dwVideoModesAvailable|= 1;
		else if(lpDDSurfaceDesc->ddpfPixelFormat.dwRGBBitCount == 24) dwVideoModesAvailable|= 2;
		else if(lpDDSurfaceDesc->ddpfPixelFormat.dwRGBBitCount == 32) dwVideoModesAvailable|= 4;
	}

	return DDENUMRET_OK;
}

DWORD DetectVideoModes(void)
{
	// videomodok enumeralasa:
	DirectDrawCreate(NULL,&lpDD,NULL);
	lpDD->EnumDisplayModes(0,NULL,NULL,DDEnumDisplayModesCallback);
	lpDD->Release();

	return dwVideoModesAvailable;
}
